--------------------------------------------------
--------------------------------------------------
--------------------------------------------------
Strategic = {}
Strategic[ARMY] = {}
Strategic[CORP] = {}
Strategic[BUTSI] = {}
Strategic[MARAUDERS] = {}
Strategic[PIRATS] = {}
Strategic[ARMY].Bases = {"base", "palace", "dam", "trainstation"}
Strategic[CORP].Bases = {"north_road", "airport", "port"}
Strategic[BUTSI].Bases = {"mountain_village"}
Strategic[MARAUDERS].Bases = {"outpost", "pirate_island"}
Strategic[ARMY].POI = nil
Strategic[CORP].POI = nil
Strategic[BUTSI].POI = {"dam", "roadblock", "road_to_airport", "port", "airport", "trainstation"}
Strategic[MARAUDERS].POI = {"mines", "outpost", "coastal_city", "north_base", "un_camp", "trainstation"}
Strategic[ARMY].NeverAttack = {"drug_deal", "north_road", "safari"}
Strategic[CORP].NeverAttack = {"drug_deal", "north_road", "safari"}
Strategic[BUTSI].NeverAttack = {"drug_deal", "north_road", "safari"}
Strategic[MARAUDERS].NeverAttack = {"drug_deal", "north_road", "safari"}
Strategic[PIRATS] = deepcopy(Strategic[MARAUDERS])
--------------------------------------------------
function thinkStrategy()
	decideAssault(ARMY)
	decideAssault(CORP)
	decideAssault(BUTSI)
	decideAssault(MARAUDERS)
	decideAssault(PIRATS)
end

function replenishPools()
	local pools = Pool
	
	local replenish = function(index,value)
		local max = value.max
		local current = value.current
		local period = value.period
		local recruits = value.recruits
		local last = value.last
		local cost = value.cost
		local total_cost = recruits * cost
		local money = Resources[index]
		local day = getVariable("time_day")
		
		if ((day - last) >= period) then

			tableLog("_strategy_", Pool)
			tableLog("_economy_", Resources)
			
			Pool[index].last = day

			if (max > current) then
			
				if (money >= total_cost) then
			
					local new_current = current + recruits
				
					if (new_current > max) then
					 
						total_cost = cost * (recruits - (new_current - max))
				
						new_current = max
					
						log("_pool_", index, "too much recruits", "arrived: ", recruits, "need: ", (recruits - (new_current - max)))
					
					end
				
					Pool[index].current = new_current
					Resources[index] = money - total_cost
					
					log("_pool_", index, "pool replenished", "cost: ", total_cost, "pool: ", new_current, "money left: ", (money - total_cost))
					
				else
				
					log("_pool_", index, "not enough money", "need: ", total_cost, "has: ", money)
					
				end
			
			else
			
				log("_pool_", index, "pool is full")
			
			end
			
		else
		
			--log("_pool_", index, "waiting", "last: ", last, "Day: ", day, "Period: ", period)
			
		end
		
	end
	
	table.foreach(pools, replenish)
	
end

function nextBase(force)
	local total_bases = getTableSize(Strategic[force].Bases)
	if (total_bases==0) then
		return nil
	end
	
	local last_base = STRATEGY_DATA[force].LastBase
	if (nil==last_base) then
		last_base = 0
	end

	local found = false
	for count = 1, total_bases, 1 do
		last_base = last_base + 1

		if (last_base > total_bases) then
			last_base = 1
		end
		
		local sector = Strategic[force].Bases[last_base]
		local sector_owner = Sectors[sector].owner
		if (sector_owner == force) then
			STRATEGY_DATA[force].LastBase = last_base
			found = true
			break
		end
	end
	
	if (found==true) then
		return Strategic[force].Bases[last_base]
	else
		return nil	
	end
	
	
--	if (not(isValid(last_base)) or (last_base == total_bases))then
--		STRATEGY_DATA[force].LastBase = 1
--		return 1
--	end
--	
--	for count = 1, total_bases, 1 do
--		last_base = last_base + 1
--		
--		if (last_base > total_bases) then
--			last_base = 1
--		end
--		
--		if 	((Sectors[Strategic[force].Bases[last_base]].owner == force) 
--		and (last_base ~= STRATEGY_DATA[force].LastBase)) then
--			
--			found = true
--			break
--		end
--	end
--		
--	if (found == true) then
--		STRATEGY_DATA[force].LastBase = last_base
--
--		return last_base
--	elseif (Sectors[Strategic[force].Bases[STRATEGY_DATA[force].LastBase]].owner == force) then
--		return STRATEGY_DATA[force].LastBase
--	else
--		return nil
--	end

end

function checkPOI(force, sector)
	local res = false

	local check = function(index, poi)
		if (sector == poi) then
			res = true
			return
		end
	end
	
	if (Strategic[force].POI == nil) then
		return true
	end
	
	table.foreach(Strategic[force].POI, check)
	
	return res
end

function checkNeverAttack(force, sector)
	local res = true
log("check_never_attack", "force:", force, " sector:", sector)

	local check = function(index, never)
log("check_never_attack", never)
		if (sector == never) then
log("check_never_attack", "FALSE")
			res = false
		end
	end
	
	if (Strategic[force].NeverAttack ~= nil) then
		table.foreach(Strategic[force].NeverAttack, check)
	end
	
	return res
end

function getSectorToAttack(force)
	local sector_to_attack = nil
	local log_id = "_strategy_"
	local value = 0
	
	local get = function(sector, data)
		if (Forces[force][data.owner] == ENEMY) then
			log(log_id, "getSectorToAttack", "relations", force, data.owner, Forces[force][data.owner])
			if (data.value > value) then
				log(log_id, "getSectorToAttack", "sector_value", data.value)
				if (sector ~= STRATEGY_DATA[force].LastTarget) then
					if ((checkPOI(force, sector) == true) and (checkNeverAttack(force, sector) == true)) then
						sector_to_attack = sector
						log(log_id, "getSectorToAttack", "current sector to attack", sector_to_attack)
						value = data.value
					else
						log(log_id, "getSectorToAttack", "sector is not in the POI list or IS in the NeverAttack list")
					end
				else
					STRATEGY_DATA[force].LastTarget = nil
				end
			else
				log(log_id, "getSectorToAttack", "value low", data.value)
			end
		end
	end
	
	table.foreach(Sectors, get)
	
	return sector_to_attack
end

function decideAssault(force)
	local log_id = "_strategy_"
	local day = tonumber(getVariable("time_day"))
	local last_day = tonumber(STRATEGY_DATA[force].LastTime)
	local period = math.random(tonumber(STRATEGY_DATA[force].Period))
	local time_passed = day - last_day
	
	if (time_passed < period) then
		return
	end
	
	STRATEGY_DATA[force].LastTime = day
	
	if (ForceActive[force] == false) then
		log(log_id, force, "have been eliminated already")
		return
	end
	
	if (Pool[force].current < 5) then
		log(log_id, "Pool too low on units")
		return
	end
	
	if ((CURRENT_ALLY == force) and (CURRENT_ALLY ~= MARAUDERS) and (CURRENT_ALLY ~= BUTSI)) then
		log(log_id, force, "are player's ally")
		return
	end
	
	if (STRATEGY_DATA[force].Moving == true) then
		log(log_id, force, "are still moving somethere")
		return
	end
	
	log(log_id, ">>>>>> day", day, "last time", last_day, "period", period)
	
	log(log_id, "let's get ready to RUMMMBBBLE!!!", force)
	
	--local base = Strategic[force].Bases[nextBase(force)]
	local base = nextBase(force)
	log(log_id, "nextBase", force, base)
	
	if not(isValid(base)) then
		log(log_id, "No bases left", force, "out of game")
		ForceActive[force] = false
		return
	end
	
	--if (base == STRATEGY_DATA[force].LastBase) then
	--	log(log_id, "Only one base left")
	--end
	
	log(log_id, "Base:", base)
	
	local target = getSectorToAttack(force)
	
	log(log_id, "Target:", target)
	
	if (target == nil) then
		log(log_id, " ")
		return
	end
	--
	STRATEGY_DATA[force].LastTarget = target
	--
	local res = findPath(force, base, target)
	local actual_target = target
	
	if (res.found == false) then
		log(log_id, "oops. cant attack", target, "by", force, "from", base)
		return
	end
	
	if (isValid(res.fight_sector)) then
		log(log_id, "OBSTACLE", res.fight_sector)
		actual_target = res.fight_sector
	end
	
	log(log_id, "new last time", STRATEGY_DATA[force].LastTime)
	log(log_id, "Moving out!", base, actual_target)
	
	ENEMY_DESTINATIONS[force] = actual_target
	
	STRATEGY_DATA[force].Moving = true

	BATTLE_DATA.Entrance = Joints[res.retreat_sector][actual_target].entrance
	if(BATTLE_DATA.Entrance==nil) then
	        BATTLE_DATA.Entrance = Joints[base][actual_target].entrance
		if(BATTLE_DATA.Entrance==nil) then
			BATTLE_DATA.Entrance = "west"
		end
	end
	
	startArmyMovement("figure_"..force, base, actual_target, "enemy_attack", res.path, res.time, Upgrades["outpost_radar"].bought)
end

function updateGameStage()
	local log_id = "game_stage"
	local sectors = sectorsUnderControl(PLAYER)
	
	log(log_id, "update", "sectors:", sectors, "kill count:", KILL_COUNT)
	
	if (sectors > (3 * (GAME_STAGE + 1))) then
		log(log_id, "update", "sectors >", tostring(3 * (GAME_STAGE + 1)))
		GAME_STAGE = GAME_STAGE + 1
		initMercs(true)
		setGameStage(GAME_STAGE)
		log(log_id, "update", "new game stage:", GAME_STAGE)
		sendMail("change_stage", nil, nil, true)
		--Emails["change_stage"].send(true)
	elseif (KILL_COUNT > (250 * (GAME_STAGE + 1))) then
		log(log_id, "update", "kill count >", tostring((GAME_STAGE + 1) * 250))
		GAME_STAGE = GAME_STAGE + 1
		initMercs(true)
		setGameStage(GAME_STAGE)
		log(log_id, "update", "new game stage:", GAME_STAGE)
		sendMail("change_stage", nil, nil, true)
		--Emails["change_stage"].send(true)
	end
	
end

function mobilizationUpdate()
	local s = Sectors
	local current_force = ""
	
	local update = function(sector, data)
	
		if (data.owner == current_force) then
			local militia_info = getMilitiaInfo(sector)
			
			if ((militia_info.num < 20) and (militia_info.num > 0)) then
				for slot = 1, 4, 1 do
					if ((militia_info[slot].num < 5) and (militia_info[slot].mtype ~= nil)) then
						if (Pool[current_force].current > 0) then
							if (militia_info[slot].mtype == nil) then
								militia_info[slot].mtype = current_force
							end
							--log("!slot_to_reduce", "mobilizationUpdate", sector, slot, militia_info[slot].num)
							setMilitia2(sector, slot, militia_info[slot].mtype, militia_info[slot].num + 1)
							Pool[current_force].current = Pool[current_force].current - 1
						end
					end
				end
			end
		end
		
	end
	
	local thru = function(force, data)
		if ((force ~= CIVILIAN) and (force ~= PLAYER)) then
			current_force = force
			table.foreach(s, update)
		end
	end
	
	table.foreach(Forces, thru)
end

function combatInit()
	spawnDefenders(BATTLE_DATA.Sector, BATTLE_DATA.Attacker, BATTLE_DATA.AttackerSize, "attackers")
	spawnMilitia()
end

function combatResults(sector, won)
	local mi = getMilitiaInfo(sector)
	local new_mi = mi
	local num = mi.num
	local current_num = num
	local slots = {}
	local dead = {}
	local num_dead = 0
	--
	log("_strategy_", "Calculating combat results for", sector)
	--
	if ( won == true ) then
		log("_strategy_", "We won! Militia out!")
		for slot = 1, 4, 1 do
			setMilitia2(sector, slot, "", 0)
		end
		return
	end
	--
	local count_dead = function(unit, mtype)
		if ( not(IsAlive(unit)) ) then
			num_dead = num_dead + 1
			
			if (dead[mtype] == nil) then
				dead[mtype] = 1
			else
				dead[mtype] = dead[mtype] + 1
			end
		end
	end
	
	table.foreach(MILITIA_DATA, count_dead)
	--
	current_num = num - num_dead
	
	if (current_num == num) then
		return
	elseif ( current_num == 0 ) then
		for slot = 1, 4, 1 do
			setMilitia2(sector, slot, "", 0)
		end
		
		return
	end
	--
	local deduct = function(slot, data)
		if ( (slot ~= "slots") and (slot ~= "num") ) then
			if ( (dead[data.mtype] ~= nil) and (dead[data.mtype] > 0) ) then
				if ( new_mi[slot].num > 0 ) then
					if ( dead[data.mtype] <= new_mi[slot].num ) then
						new_mi[slot].num = new_mi[slot].num - dead[data.mtype]
						dead[data.mtype] = 0
					else
						dead[data.mtype] = dead[data.mtype] - new_mi[slot].num
						new_mi[slot].num = 0
					end
				end
			end
		end
	end
	
	table.foreach(mi, deduct)
	--
	local update = function(slot, data)
		if ( (slot ~= "slots") and (slot ~= "num") ) then
			local mtype = data.mtype
			local num = data.num
			
			if ( data.mtype == nil ) then
				mtype = ""
			end
			
			if ( data.num == nil ) then
				num = 0
			end
			
			setMilitia2(sector, slot, mtype, num)
		end
	end
	
	table.foreach(new_mi, update)
	
end


